<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (Schema::hasColumn('releases', 'composer_lastname')) {
            Schema::table('releases', function (Blueprint $table) {
                $table->dropColumn('composer_lastname');
            });
        }
        Schema::table('releases', function (Blueprint $table) {
            $table->string('composer_lastname')->nullable()->after('composer');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('releases', function (Blueprint $table) {
            $table->dropColumn('composer_lastname');
        });
    }
};
 